package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.ReminderLogDTO;
import gov.va.med.mhv.calendar.model.ReminderLog;
import org.springframework.core.convert.converter.Converter;

public class ReminderLogConverter implements Converter<ReminderLog, ReminderLogDTO> {

	@Override
	public ReminderLogDTO convert(ReminderLog source) {
		ReminderLogDTO target = new ReminderLogDTO();
		
		target.setId(source.getId());
		target.setScheduleId(source.getScheduleId());
		target.setDatetimeRun(source.getDatetimeRun());
	
		return target;
	}
	

	public ReminderLog convert(ReminderLogDTO source) {
		ReminderLog target = new ReminderLog();
		
		target.setId(source.getId());
		target.setScheduleId(source.getScheduleId());
		target.setDatetimeRun(source.getDatetimeRun());
	
		return target;
	}
	
	public List<ReminderLogDTO> convert(List<ReminderLog> source) {
		List <ReminderLogDTO> reminderLogDto= null;
		if(null !=source) {
			reminderLogDto = new ArrayList<ReminderLogDTO>();

			for (ReminderLog reminderLog: source) {
				reminderLogDto.add(this.convert(reminderLog));
			}

		}

		return reminderLogDto;
	}


}
